<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectStagesTable extends Migration {

	public function up()
	{
		Schema::create('project_stages', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name')->nullable();
			$table->datetime('date_created')->nullable();
			$table->datetime('delivery_date')->nullable();
			$table->text('note')->nullable();
			$table->integer('project_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('project_stages');
	}
}