<?php

namespace Models/MarketingChannel;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class MarketingChannel extends Model 
{

    protected $table = 'marketing_channels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function leads()
    {
        return $this->belongsToMany('Lead', 'marketing_channel_id');
    }

}