<?php

namespace Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PropertySpecificationProject extends Model 
{

    protected $table = 'property_specification_projects';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function property_specification()
    {
        return $this->belongsTo('PropertySpecification', 'property_specification_id');
    }

    public function project()
    {
        return $this->belongsTo('Project', 'project_id');
    }

}