<?php

namespace Event;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Event extends Eloquent {

	protected $table = 'Event';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function times()
	{
		return $this->hasMany('Time', 'id');
	}

	public function locations()
	{
		return $this->hasMany('EventLocation', 'id');
	}

}