<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerTable extends Migration {

	public function up()
	{
		Schema::create('customer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('cutomer_unique_id', 191);
			$table->string('first_name', 191)->nullable();
			$table->string('last_name', 191)->nullable();
			$table->integer('mobile');
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->text('address');
			$table->text('about');
			$table->string('profile_img', 191)->nullable();
			$table->string('location', 191)->nullable();
			$table->string('society', 191)->nullable();
			$table->string('RWA', 191)->nullable();
			$table->string('latitude')->nullable();
			$table->string('longitude');
			$table->smallInteger('otp')->nullable();
			$table->boolean('is_provider')->default(0);
			$table->tinyInteger('status')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('customer');
	}
}