<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBusinessSectorsTable extends Migration {

	public function up()
	{
		Schema::create('businessSectors', function(Blueprint $table) {
			$table->bigIncrements('id', true)->primary();
			$table->string('sectors_code', 255)->unique()->nullable()->default('NULL');
			$table->string('name', 255)->unique()->default('NULL');
			$table->longText('description')->unique()->nullable()->default('NULL');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('businessSectors');
	}
}