<?php

namespace App\Modules\Blog\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Post extends Eloquent {

	protected $table = 'blog_posts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $guarded = array('id');

	public function category()
	{
		return $this->belongsTo('Category', 'category_id');
	}

	public function tags()
	{
		return $this->belongsToMany('PostTag');
	}

}