<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->tinyInteger('entity_type')->unsigned()->default('1');
			$table->integer('entity_id')->unsigned();
			$table->tinyInteger('type')->unsigned()->default('1');
			$table->string('path', 256);
			$table->json('attributes')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}