<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRentalCarsReservationTable extends Migration {

	public function up()
	{
		Schema::create('rental_cars_reservation', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('rental_car_id')->unsigned();
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->string('phone')->nullable();
			$table->text('address')->nullable();
			$table->string('rental_type')->nullable();
			$table->date('start_at')->nullable();
			$table->boolean('rental_active')->default(true);
			$table->boolean('rental_availabilty')->nullable()->default(true);
			$table->string('payment_method')->nullable();
			$table->double('total_payment', 8,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('rental_cars_reservation');
	}
}