<?php

namespace App\Models;

class Agency extends Eloquent {

	protected $table = 'agencies';
	public $timestamps = true;
	protected $fillable = array('id', 'name_ar', 'name_en', 'description_ar', 'description_en', 'record_number', 'logo', 'active', 'availablity', 'country_id', 'brand_id', 'year_founded', 'day_off_id', 'timestamps');

	public function contact()
	{
		return $this->morphOne('App\Models\Contact', 'contactable');
	}

	public function brand()
	{
		return $this->belongsTo('App\Models\Brand');
	}

	public function reviews()
	{
		return $this->morphToMany('App\Models\User', 'reviewable');
	}

	public function favourites()
	{
		return $this->morphToMany('App\Models\User', 'favouriable');
	}

	public function country()
	{
		return $this->belongsTo('App\Models\Country');
	}

	public function branches()
	{
		return $this->morphMany('App\Models\Branch', 'branchable');
	}

	public function work_time()
	{
		return $this->morphOne('WorkTime', 'workable');
	}

	public function cars()
	{
		return $this->morphToMany('App\Models\Car', 'carable');
	}

	public function check_reservations()
	{
		return $this->morphToMany('App\Models\User', 'checkable');
	}

	public function categories()
	{
		return $this->morphToMany('App\Models\Category', 'categorizable');
	}

	public function policies()
	{
		return $this->morphMany('App\Models\Policy', 'policiable');
	}

	public function day_offs()
	{
		return $this->hasMany('App\Models\DayOffs');
	}

}