<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCarsShowRoomsTable extends Migration {

	public function up()
	{
		Schema::create('cars_show_rooms', function(Blueprint $table) {
			$table->bigIncrements('id');
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->text('description_ar')->nullable();
			$table->text('description_en');
			$table->string('record_number')->nullable();
			$table->string('logo')->nullable();
			$table->boolean('active')->default(true);
			$table->boolean('availablity')->default(true);
			$table->bigInteger('day_off_id')->unsigned();
			$table->bigInteger('country_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('cars_show_rooms');
	}
}