<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('productable_type');
			$table->bigInteger('productable_id');
			$table->enum('type', array('new', 'used'))->nullable();
			$table->string('name_ar')->nullable();
			$table->string('name_en')->nullable();
			$table->double('price', 8,2)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}