<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCartMenuItemTable extends Migration {

	public function up()
	{
		Schema::create('cart_menu_item', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('cart_id')->unsigned();
			$table->integer('menu_item_id')->unsigned();
			$table->integer('quantity')->default('1');
			$table->decimal('price')->default('0');
			$table->text('special_instructions')->nullable();
			$table->json('saus');
			$table->json('size');
			$table->json('type');
		});
	}

	public function down()
	{
		Schema::drop('cart_menu_item');
	}
}