<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryRoutesTable extends Migration {

	public function up()
	{
		Schema::create('delivery_routes', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('delivery_id')->unsigned();
			$table->decimal('delivery_fee');
			$table->text('start_latitude');
			$table->text('start_longitude');
			$table->text('end_latitude');
			$table->text('end_longitude');
			$table->string('duration');
		});
	}

	public function down()
	{
		Schema::drop('delivery_routes');
	}
}