<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderInvoicesTable extends Migration {

	public function up()
	{
		Schema::create('order_invoices', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->unsigned();
			$table->decimal('total_cost');
			$table->decimal('delivery_fee')->default('0');
			$table->integer('resturant_vat');
			$table->integer('resturant_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('order_invoices');
	}
}