<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResturantsTable extends Migration {

	public function up()
	{
		Schema::create('resturants', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name');
			$table->text('address');
			$table->string('work_hours');
			$table->integer('vat');
			$table->integer('type')->default('0');
			$table->decimal('delivery_fee')->default('0');
			$table->decimal('minimum_order')->default('0');
			$table->string('delivery_time');
			$table->text('latitude');
			$table->text('longitude');
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('resturants');
	}
}