<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Applicant extends Eloquent {

	protected $table = 'applicants';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function applications()
	{
		return $this->hasMany('Application');
	}

	public function universities()
	{
		return $this->belongsToMany('University');
	}

	public function employers()
	{
		return $this->hasMany('ApplicantEmployers');
	}

}