<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCrawlerCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('crawler_categories', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('bot_id')->unsigned();
			$table->string('link');
			$table->string('title');
			$table->string('status');
			$table->tinyInteger('attempts')->default('0');
			$table->timestamp('crawled_at');
			$table->integer('last_page');
			$table->timestamp('seller_requested_at');
			$table->timestamps();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('crawler_categories');
	}
}