<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketerTable extends Migration {

	public function up()
	{
		Schema::create('marketer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name')->nullable();
			$table->string('email')->nullable();
			$table->string('phone', address)->nullable();
			$table->string('image')->nullable();
			$table->bigInteger('country_id');
			$table->double('experience', 2,2)->nullable();
			$table->bigInteger('city_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('marketer');
	}
}