<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUserCarTable extends Migration {

	public function up()
	{
		Schema::create('user_car', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('car_model_id')->nullable();
			$table->string('plate_number', 100)->nullable();
			$table->string('plate_code', 100)->nullable();
			$table->string('name', 200)->nullable();
			$table->enum('car_type', array('suv', 'sedan', 'pickup', 'bike'));
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('user_car');
	}
}