<?php

namespace App\Models;

class Payment extends Eloquent {

	protected $table = 'payments';
	public $timestamps = true;
	protected $fillable = array('user_id', 'booking_id', 'total_amount');

	public function user()
	{
		return $this->hasOne('App\Models\User', 'user_id');
	}

	public function bookingInfo()
	{
		return $this->hasOne('App\Models\BookingInfo', 'booking_id');
	}

}