<?php

namespace App;

class Contrat extends Eloquent {

	protected $table = 'contrats';
	public $timestamps = true;
	protected $fillable = array('code_contrat', 'id_saver', 'id_locataire', 'id_building', 'date_debut', 'montant_loyer', 'nbre_mois', 'reduction', 'etat');
	protected $visible = array('code_contrat', 'id_saver', 'id_locataire', 'id_building', 'date_debut', 'montant_loyer', 'nbre_mois', 'reduction', 'etat');

	public function proprio()
	{
		return $this->belongsTo('App\User', 'id_locataire');
	}

	public function building()
	{
		return $this->belongsTo('App\Building', 'id_building');
	}

	public function versements_loyer()
	{
		return $this->hasMany('App\Versement_locataire', 'id_contrat');
	}

}