<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionTable extends Migration {

	public function up()
	{
		Schema::create('transaction', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subscription_id')->unsigned();
			$table->integer('subtype_id')->unsigned();
			$table->integer('ipcountry_id')->unsigned();
			$table->float('sum');
			$table->enum('type', array('initial', 'rebill', 'refund', 'chargeback'))->index();
			$table->string('ip')->index();
		});
	}

	public function down()
	{
		Schema::drop('transaction');
	}
}