<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->foreign('partner_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('subtype_id')->references('id')->on('subtype')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('platform_id')->references('id')->on('platform')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->foreign('subscription_id')->references('id')->on('transaction')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->foreign('subtype_id')->references('id')->on('subtype')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->foreign('ipcountry_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('session', function(Blueprint $table) {
			$table->foreign('login_id')->references('id')->on('login')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('login', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('login', function(Blueprint $table) {
			$table->foreign('ipcountry_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_country_id_foreign');
		});
		Schema::table('user', function(Blueprint $table) {
			$table->dropForeign('user_partner_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_subtype_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_platform_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_country_id_foreign');
		});
		Schema::table('subscription', function(Blueprint $table) {
			$table->dropForeign('subscription_user_id_foreign');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->dropForeign('transaction_subscription_id_foreign');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->dropForeign('transaction_subtype_id_foreign');
		});
		Schema::table('transaction', function(Blueprint $table) {
			$table->dropForeign('transaction_ipcountry_id_foreign');
		});
		Schema::table('session', function(Blueprint $table) {
			$table->dropForeign('session_login_id_foreign');
		});
		Schema::table('login', function(Blueprint $table) {
			$table->dropForeign('login_user_id_foreign');
		});
		Schema::table('login', function(Blueprint $table) {
			$table->dropForeign('login_ipcountry_id_foreign');
		});
	}
}