<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransactionsTable extends Migration {

	public function up()
	{
		Schema::create('transactions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('date_of_payment');
			$table->bigInteger('user_id')->unsigned();
			$table->bigInteger('order_id')->unsigned();
			$table->bigInteger('order_amount')->unsigned();
			$table->string('payment_method');
			$table->bigInteger('status')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('transactions');
	}
}