<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('Quai', function(Blueprint $table) {
			$table->foreign('id_direction')->references('id')->on('Direction')
						->onDelete('set null')
						->onUpdate('cascade');
		});
		Schema::table('Notification', function(Blueprint $table) {
			$table->foreign('id_barge')->references('id')->on('Barge')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Horaire', function(Blueprint $table) {
			$table->foreign('id_quai')->references('id')->on('Quai')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('Horaire', function(Blueprint $table) {
			$table->foreign('id_barge')->references('id')->on('Barge')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('Quai', function(Blueprint $table) {
			$table->dropForeign('Quai_id_direction_foreign');
		});
		Schema::table('Notification', function(Blueprint $table) {
			$table->dropForeign('Notification_id_barge_foreign');
		});
		Schema::table('Horaire', function(Blueprint $table) {
			$table->dropForeign('Horaire_id_quai_foreign');
		});
		Schema::table('Horaire', function(Blueprint $table) {
			$table->dropForeign('Horaire_id_barge_foreign');
		});
	}
}