<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMarketerTable extends Migration {

	public function up()
	{
		Schema::create('marketer', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('name', 250);
			$table->string('photo', 250)->nullable();
			$table->string('id_number', 250)->nullable();
			$table->string('id_photo', 250)->nullable();
			$table->string('qualification', 250)->nullable();
			$table->string('bank_photo', 250)->nullable();
			$table->string('bank_account', 250)->nullable();
			$table->string('cv_url', 250)->nullable();
			$table->integer('nationality_id')->nullable();
			$table->tinyInteger('gender')->nullable();
			$table->string('mobile', 250)->nullable();
			$table->string('email', 250)->nullable();
			$table->integer('country_id')->nullable();
			$table->integer('city_id')->nullable();
			$table->string('license_photo', 250)->nullable();
			$table->string('license_no', 250)->nullable();
			$table->string('car_type', 250)->nullable();
			$table->integer('from_company_id')->nullable();
			$table->integer('job_type_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('marketer');
	}
}