<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePressOrdersTable extends Migration {

	public function up()
	{
		Schema::create('press_orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->nullable();
			$table->decimal('total', 15,4)->nullable();
			$table->decimal('commission', 15,4)->nullable();
			$table->integer('order_status_id')->nullable();
			$table->integer('currency_id')->nullable();
			$table->string('comment', 500)->nullable();
			$table->integer('press_id')->nullable();
			$table->integer('captain_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('press_orders');
	}
}