<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAddressTable extends Migration {

	public function up()
	{
		Schema::create('address', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('firstname', 250);
			$table->string('lastname', 250);
			$table->integer('country_id')->unsigned();
			$table->integer('city_id')->unsigned();
			$table->text('descreption');
			$table->string('postno', 250);
			$table->string('mobile', 250);
			$table->integer('user_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('address');
	}
}