<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePocketTable extends Migration {

	public function up()
	{
		Schema::create('pocket', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->decimal('store')->nullable()->default('0');
			$table->decimal('press', 15,4)->nullable();
			$table->decimal('booking', 15,4)->nullable();
			$table->decimal('ads', 15,4)->nullable();
			$table->decimal('gifts', 15,4)->nullable();
			$table->decimal('transfers', 15,4)->nullable();
			$table->decimal('total', 15,4)->nullable();
			$table->integer('marketer_id')->unsigned()->nullable();
			$table->integer('press_id')->unsigned()->nullable();
			$table->integer('store_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pocket');
	}
}