<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductOptionValueTable extends Migration {

	public function up()
	{
		Schema::create('product_option_value', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_option_id')->nullable();
			$table->integer('product_id')->unsigned();
			$table->integer('option_id')->unsigned();
			$table->integer('option_value_id')->nullable();
			$table->integer('quantity')->nullable();
			$table->tinyInteger('subtract')->nullable();
			$table->decimal('price', 15,4)->nullable();
			$table->string('price_prefix', 1)->nullable();
			$table->integer('points')->nullable();
			$table->string('points_prefix', 1)->nullable();
			$table->decimal('weight', 15,4)->nullable();
			$table->string('weight_prefix', 1)->nullable();
		});
	}

	public function down()
	{
		Schema::drop('product_option_value');
	}
}