<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTranslationTable extends Migration {

	public function up()
	{
		Schema::create('product_translation', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('product_id')->unsigned()->nullable();
			$table->string('name', 250);
			$table->text('descreption')->nullable();
			$table->text('tag')->nullable();
			$table->integer('language_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('product_translation');
	}
}