<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('product_image', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('shipping_address_id')->references('id')->on('address')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('convention', function(Blueprint $table) {
			$table->foreign('faculty_id')->references('id')->on('faculties')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_translation', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_translation', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('category_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_class_trans', function(Blueprint $table) {
			$table->foreign('tax_class_id')->references('id')->on('tax_class')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('tax_class_trans', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('weight_class_trans', function(Blueprint $table) {
			$table->foreign('weight_class_id')->references('id')->on('weight_class')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('weight_class_trans', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('length_class_trans', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('length_class_trans', function(Blueprint $table) {
			$table->foreign('length_class_id')->references('id')->on('length_class')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('announce_translation', function(Blueprint $table) {
			$table->foreign('announce_id')->references('id')->on('ads')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('announce_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attribute_translation', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attribute')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('attribute_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->foreign('attribute_id')->references('id')->on('attribute')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('brands_translation', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('brands_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_rate', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_rate', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_status_translation', function(Blueprint $table) {
			$table->foreign('order_status_id')->references('id')->on('order_status')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order_status_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favourite', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('favourite', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('watched_product', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('watched_product', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('option_translation', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('option_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('option_value', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('option_value_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->foreign('option_id')->references('id')->on('option')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_messages', function(Blueprint $table) {
			$table->foreign('sender_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_messages', function(Blueprint $table) {
			$table->foreign('press_id')->references('id')->on('press')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_messages', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_partners', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_partners', function(Blueprint $table) {
			$table->foreign('press_id')->references('id')->on('press')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_visits', function(Blueprint $table) {
			$table->foreign('press_id')->references('id')->on('press')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_rating', function(Blueprint $table) {
			$table->foreign('press_id')->references('id')->on('press')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_rating', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_rating_items', function(Blueprint $table) {
			$table->foreign('press_rate_id')->references('id')->on('product_rate')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('press_rating_items', function(Blueprint $table) {
			$table->foreign('rating_item_id')->references('id')->on('rating_items')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages_translation', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pages_translation', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('selfie', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('warning', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('gifts', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pocket', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pocket', function(Blueprint $table) {
			$table->foreign('press_id')->references('id')->on('press')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pocket', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('department_trans', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('department_trans', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('language')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('complaint_proposal', function(Blueprint $table) {
			$table->foreign('department_id')->references('id')->on('department')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marketer_partners', function(Blueprint $table) {
			$table->foreign('store_id')->references('id')->on('stores')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marketer_partners', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->foreign('marketer_id')->references('id')->on('marketer')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('convention_update', function(Blueprint $table) {
			$table->foreign('convention_id')->references('id')->on('convention')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers_orders', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('category')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers_products', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers_products', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_prices', function(Blueprint $table) {
			$table->foreign('shipping_company_id')->references('id')->on('shipping_companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_prices', function(Blueprint $table) {
			$table->foreign('from_c_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_prices', function(Blueprint $table) {
			$table->foreign('to_c_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->foreign('shipping_company_id')->references('id')->on('shipping_companies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->foreign('paymnent_method_id')->references('id')->on('payment_method')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('product')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->foreign('from_c_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->foreign('to_c_id')->references('id')->on('countries')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('help', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('product_image', function(Blueprint $table) {
			$table->dropForeign('product_image_product_id_foreign');
		});
		Schema::table('product_discount', function(Blueprint $table) {
			$table->dropForeign('product_discount_product_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_shipping_address_id_foreign');
		});
		Schema::table('convention', function(Blueprint $table) {
			$table->dropForeign('convention_faculty_id_foreign');
		});
		Schema::table('product_translation', function(Blueprint $table) {
			$table->dropForeign('product_translation_product_id_foreign');
		});
		Schema::table('product_translation', function(Blueprint $table) {
			$table->dropForeign('product_translation_language_id_foreign');
		});
		Schema::table('category_translation', function(Blueprint $table) {
			$table->dropForeign('category_translation_category_id_foreign');
		});
		Schema::table('category_translation', function(Blueprint $table) {
			$table->dropForeign('category_translation_language_id_foreign');
		});
		Schema::table('tax_class_trans', function(Blueprint $table) {
			$table->dropForeign('tax_class_trans_tax_class_id_foreign');
		});
		Schema::table('tax_class_trans', function(Blueprint $table) {
			$table->dropForeign('tax_class_trans_language_id_foreign');
		});
		Schema::table('weight_class_trans', function(Blueprint $table) {
			$table->dropForeign('weight_class_trans_weight_class_id_foreign');
		});
		Schema::table('weight_class_trans', function(Blueprint $table) {
			$table->dropForeign('weight_class_trans_language_id_foreign');
		});
		Schema::table('length_class_trans', function(Blueprint $table) {
			$table->dropForeign('length_class_trans_language_id_foreign');
		});
		Schema::table('length_class_trans', function(Blueprint $table) {
			$table->dropForeign('length_class_trans_length_class_id_foreign');
		});
		Schema::table('announce_translation', function(Blueprint $table) {
			$table->dropForeign('announce_translation_announce_id_foreign');
		});
		Schema::table('announce_translation', function(Blueprint $table) {
			$table->dropForeign('announce_translation_language_id_foreign');
		});
		Schema::table('attribute_translation', function(Blueprint $table) {
			$table->dropForeign('attribute_translation_attribute_id_foreign');
		});
		Schema::table('attribute_translation', function(Blueprint $table) {
			$table->dropForeign('attribute_translation_language_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_product_id_foreign');
		});
		Schema::table('product_attribute', function(Blueprint $table) {
			$table->dropForeign('product_attribute_attribute_id_foreign');
		});
		Schema::table('brands_translation', function(Blueprint $table) {
			$table->dropForeign('brands_translation_brand_id_foreign');
		});
		Schema::table('brands_translation', function(Blueprint $table) {
			$table->dropForeign('brands_translation_language_id_foreign');
		});
		Schema::table('product_rate', function(Blueprint $table) {
			$table->dropForeign('product_rate_user_id_foreign');
		});
		Schema::table('product_rate', function(Blueprint $table) {
			$table->dropForeign('product_rate_product_id_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_country_id_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_city_id_foreign');
		});
		Schema::table('address', function(Blueprint $table) {
			$table->dropForeign('address_user_id_foreign');
		});
		Schema::table('order_status_translation', function(Blueprint $table) {
			$table->dropForeign('order_status_translation_order_status_id_foreign');
		});
		Schema::table('order_status_translation', function(Blueprint $table) {
			$table->dropForeign('order_status_translation_language_id_foreign');
		});
		Schema::table('favourite', function(Blueprint $table) {
			$table->dropForeign('favourite_product_id_foreign');
		});
		Schema::table('favourite', function(Blueprint $table) {
			$table->dropForeign('favourite_user_id_foreign');
		});
		Schema::table('watched_product', function(Blueprint $table) {
			$table->dropForeign('watched_product_product_id_foreign');
		});
		Schema::table('watched_product', function(Blueprint $table) {
			$table->dropForeign('watched_product_user_id_foreign');
		});
		Schema::table('option_translation', function(Blueprint $table) {
			$table->dropForeign('option_translation_option_id_foreign');
		});
		Schema::table('option_translation', function(Blueprint $table) {
			$table->dropForeign('option_translation_language_id_foreign');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->dropForeign('product_option_product_id_foreign');
		});
		Schema::table('product_option', function(Blueprint $table) {
			$table->dropForeign('product_option_option_id_foreign');
		});
		Schema::table('option_value', function(Blueprint $table) {
			$table->dropForeign('option_value_option_id_foreign');
		});
		Schema::table('option_value_translation', function(Blueprint $table) {
			$table->dropForeign('option_value_translation_language_id_foreign');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->dropForeign('product_option_value_product_id_foreign');
		});
		Schema::table('product_option_value', function(Blueprint $table) {
			$table->dropForeign('product_option_value_option_id_foreign');
		});
		Schema::table('press_messages', function(Blueprint $table) {
			$table->dropForeign('press_messages_sender_id_foreign');
		});
		Schema::table('press_messages', function(Blueprint $table) {
			$table->dropForeign('press_messages_press_id_foreign');
		});
		Schema::table('press_messages', function(Blueprint $table) {
			$table->dropForeign('press_messages_marketer_id_foreign');
		});
		Schema::table('press_partners', function(Blueprint $table) {
			$table->dropForeign('press_partners_store_id_foreign');
		});
		Schema::table('press_partners', function(Blueprint $table) {
			$table->dropForeign('press_partners_press_id_foreign');
		});
		Schema::table('press_visits', function(Blueprint $table) {
			$table->dropForeign('press_visits_press_id_foreign');
		});
		Schema::table('press_rating', function(Blueprint $table) {
			$table->dropForeign('press_rating_press_id_foreign');
		});
		Schema::table('press_rating', function(Blueprint $table) {
			$table->dropForeign('press_rating_marketer_id_foreign');
		});
		Schema::table('press_rating_items', function(Blueprint $table) {
			$table->dropForeign('press_rating_items_press_rate_id_foreign');
		});
		Schema::table('press_rating_items', function(Blueprint $table) {
			$table->dropForeign('press_rating_items_rating_item_id_foreign');
		});
		Schema::table('pages_translation', function(Blueprint $table) {
			$table->dropForeign('pages_translation_page_id_foreign');
		});
		Schema::table('pages_translation', function(Blueprint $table) {
			$table->dropForeign('pages_translation_language_id_foreign');
		});
		Schema::table('statements', function(Blueprint $table) {
			$table->dropForeign('statements_marketer_id_foreign');
		});
		Schema::table('selfie', function(Blueprint $table) {
			$table->dropForeign('selfie_marketer_id_foreign');
		});
		Schema::table('warning', function(Blueprint $table) {
			$table->dropForeign('warning_marketer_id_foreign');
		});
		Schema::table('gifts', function(Blueprint $table) {
			$table->dropForeign('gifts_marketer_id_foreign');
		});
		Schema::table('pocket', function(Blueprint $table) {
			$table->dropForeign('pocket_marketer_id_foreign');
		});
		Schema::table('pocket', function(Blueprint $table) {
			$table->dropForeign('pocket_press_id_foreign');
		});
		Schema::table('pocket', function(Blueprint $table) {
			$table->dropForeign('pocket_store_id_foreign');
		});
		Schema::table('posts', function(Blueprint $table) {
			$table->dropForeign('posts_marketer_id_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_language_id_foreign');
		});
		Schema::table('department_trans', function(Blueprint $table) {
			$table->dropForeign('department_trans_department_id_foreign');
		});
		Schema::table('department_trans', function(Blueprint $table) {
			$table->dropForeign('department_trans_language_id_foreign');
		});
		Schema::table('complaint_proposal', function(Blueprint $table) {
			$table->dropForeign('complaint_proposal_department_id_foreign');
		});
		Schema::table('marketer_partners', function(Blueprint $table) {
			$table->dropForeign('marketer_partners_store_id_foreign');
		});
		Schema::table('marketer_partners', function(Blueprint $table) {
			$table->dropForeign('marketer_partners_marketer_id_foreign');
		});
		Schema::table('alerts', function(Blueprint $table) {
			$table->dropForeign('alerts_marketer_id_foreign');
		});
		Schema::table('convention_update', function(Blueprint $table) {
			$table->dropForeign('convention_update_convention_id_foreign');
		});
		Schema::table('offers_orders', function(Blueprint $table) {
			$table->dropForeign('offers_orders_category_id_foreign');
		});
		Schema::table('offers_products', function(Blueprint $table) {
			$table->dropForeign('offers_products_offer_id_foreign');
		});
		Schema::table('offers_products', function(Blueprint $table) {
			$table->dropForeign('offers_products_product_id_foreign');
		});
		Schema::table('shipping_prices', function(Blueprint $table) {
			$table->dropForeign('shipping_prices_shipping_company_id_foreign');
		});
		Schema::table('shipping_prices', function(Blueprint $table) {
			$table->dropForeign('shipping_prices_from_c_id_foreign');
		});
		Schema::table('shipping_prices', function(Blueprint $table) {
			$table->dropForeign('shipping_prices_to_c_id_foreign');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->dropForeign('shipping_orders_shipping_company_id_foreign');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->dropForeign('shipping_orders_paymnent_method_id_foreign');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->dropForeign('shipping_orders_product_id_foreign');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->dropForeign('shipping_orders_from_c_id_foreign');
		});
		Schema::table('shipping_orders', function(Blueprint $table) {
			$table->dropForeign('shipping_orders_to_c_id_foreign');
		});
		Schema::table('help', function(Blueprint $table) {
			$table->dropForeign('help_user_id_foreign');
		});
	}
}