<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTransferFeesTable extends Migration {

	public function up()
	{
		Schema::create('transfer_fees', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('country_id')->unsigned()->nullable();
			$table->integer('currency_id')->unsigned()->nullable();
			$table->integer('interval_id')->unsigned()->nullable();
			$table->string('slug')->nullable();
			$table->string('anount')->nullable();
			$table->string('status', 10)->nullable()->default('0');
		});
	}

	public function down()
	{
		Schema::drop('transfer_fees');
	}
}