<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Game extends Model 
{

    protected $table = 'games';
    public $timestamps = false;

    public function user()
    {
        return $this->belongsTo('User');
    }

    public function game_clicks()
    {
        return $this->hasMany('GameClick');
    }

    public function game_votes()
    {
        return $this->hasMany('GameVote');
    }

    public function comments()
    {
        return $this->hasMany('Comment');
    }

    public function screenshots()
    {
        return $this->hasMany('ScreenShot');
    }

}