<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateWalletsTable extends Migration {

	public function up()
	{
		Schema::create('wallets', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('currency', 4);
			$table->string('type', 2);
			$table->string('color', 7);
			$table->string('title', 100);
			$table->string('description', 600);
			$table->integer('user_id')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('wallets');
	}
}