<?php

namespace Models/Reservations;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Reservations extends Eloquent {

	protected $table = 'reservations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function user()
	{
		return $this->belongsTo('Users', 'user_id');
	}

	public function course()
	{
		return $this->belongsTo('Courses', 'course_id');
	}

	public function offer_detail()
	{
		return $this->belongsTo('OffersDetails', 'offer_details_id');
	}

}