<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 191);
			$table->string('email', 191)->unique();
			$table->string('password', 191);
			$table->string('social_type', 191)->nullable();
			$table->string('social_token', 191)->nullable();
			$table->boolean('is_newsletter');
			$table->bigInteger('workplace_id')->unsigned()->nullable();
			$table->string('identitiy');
			$table->string('licence')->nullable();
			$table->enum('type', array('user', 'doctor'));
			$table->string('image', 191)->nullable();
			$table->string('country_id');
			$table->string('birth_date', 191)->nullable();
			$table->enum('gender', array('male', 'female'));
			$table->timestamps();
			$table->softDeletes();
			$table->string('height')->nullable();
			$table->string('height_unit')->nullable();
			$table->string('weight')->nullable();
			$table->string('weight_unit')->nullable();
			$table->string('target_weight', 191)->nullable();
			$table->bigInteger('package_id')->unsigned();
			$table->string('domain')->nullable();
			$table->string('city_id');
			$table->string('username')->nullable();
			$table->string('created_by');
			$table->string('updated_by');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}