<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketsTable extends Migration {

	public function up()
	{
		Schema::create('tickets', function(Blueprint $table) {
			$table->increments('id');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('statusID')->default('1');
			$table->integer('roleID')->unsigned()->nullable();
			$table->integer('onCallTechID')->unsigned()->nullable();
			$table->integer('userID')->unsigned();
			$table->integer('technologyID')->unsigned()->nullable();
			$table->integer('affectedPartID')->unsigned()->nullable();
			$table->integer('configID')->unsigned()->nullable();
			$table->datetime('requiredDate')->nullable();
			$table->boolean('outage')->default(0);
			$table->integer('priority')->default('10');
			$table->string('replacementPartNum')->nullable();
			$table->string('alarmDescription')->nullable();
			$table->string('beforeGC')->nullable();
			$table->string('sow')->nullable();
			$table->boolean('restrictAccess')->default(0);
		});
	}

	public function down()
	{
		Schema::drop('tickets');
	}
}