<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class WorkOrder extends Eloquent {

	protected $table = 'workOrders';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function quote()
	{
		return $this->belongsTo('BidQuote', 'id');
	}

	public function user()
	{
		return $this->belongsTo('User', 'id');
	}

}