<?php

namespace App/Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Companygallery extends Eloquent {

	protected $table = 'company_gallery';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('branch_id', 'path', 'company_id', 'type');

	public function company()
	{
		return $this->belongsTo('App/Models\Company', 'company_id');
	}

}