<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FreelanceBankAccount extends Eloquent {

	protected $table = 'fl_bank_accounts';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fl_users_id', 'bank_name', 'name', 'acc_no', 'ifsc', 'branch_name');

	public function freelanceUser()
	{
		return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id');
	}

}