<?php

namespace App\Models;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class FreelancerPersonalInfo extends Eloquent {

	protected $table = 'fl_personal_infos';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('fl_users_id', 'name', 'profile_photo', 'gender', 'state', 'address', 'pin');

	public function freelanceUser()
	{
		return $this->belongsTo('App\Models\FreelanceUsers', 'fl_user_id');
	}

}