<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRevisionsTable extends Migration {

	public function up()
	{
		Schema::create('revisions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('site_user_id')->unsigned()->index();
			$table->integer('revisionable_id');
			$table->string('revisionable_type');
			$table->longText('data');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('revisions');
	}
}