<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->string('email', 200)->unique();
			$table->string('password', 200);
			$table->string('phone', 200)->nullable();
			$table->longText('address');
			$table->boolean('is_active')->default(1);
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}