<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePermissionsTable extends Migration {

	public function up()
	{
		Schema::create('permissions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->integer('role_id')->unsigned()->nullable();
			$table->datetime('create_at');
			$table->datetime('update_at')->nullable();
			$table->integer('create_by')->unsigned();
			$table->integer('update_by')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('permissions');
	}
}