<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('car_types', function(Blueprint $table) {
			$table->foreign('update_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_types', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('update_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workshops', function(Blueprint $table) {
			$table->foreign('active_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('update_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->foreign('update_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->foreign('workshop_id')->references('id')->on('workshops')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->foreign('car_type_id')->references('id')->on('car_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->foreign('car_model_id')->references('id')->on('car_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('receipts', function(Blueprint $table) {
			$table->foreign('customer_service_id')->references('id')->on('customer_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('customers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->foreign('workshop_service_id')->references('id')->on('workshop_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->foreign('receipt_id')->references('id')->on('receipts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->foreign('customer_service_id')->references('id')->on('customer_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('update_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('create_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->foreign('update_by')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->foreign('permission_id')->references('id')->on('permissions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('car_types', function(Blueprint $table) {
			$table->dropForeign('car_types_update_by_foreign');
		});
		Schema::table('car_types', function(Blueprint $table) {
			$table->dropForeign('car_types_create_by_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_create_by_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_update_by_foreign');
		});
		Schema::table('workshops', function(Blueprint $table) {
			$table->dropForeign('workshops_active_by_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_create_by_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_update_by_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_create_by_foreign');
		});
		Schema::table('roles', function(Blueprint $table) {
			$table->dropForeign('roles_update_by_foreign');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->dropForeign('workshop_services_workshop_id_foreign');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->dropForeign('workshop_services_service_id_foreign');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->dropForeign('workshop_services_car_type_id_foreign');
		});
		Schema::table('workshop_services', function(Blueprint $table) {
			$table->dropForeign('workshop_services_car_model_id_foreign');
		});
		Schema::table('receipts', function(Blueprint $table) {
			$table->dropForeign('receipts_customer_service_id_foreign');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->dropForeign('customer_services_customer_id_foreign');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->dropForeign('customer_services_workshop_service_id_foreign');
		});
		Schema::table('customer_services', function(Blueprint $table) {
			$table->dropForeign('customer_services_receipt_id_foreign');
		});
		Schema::table('rates', function(Blueprint $table) {
			$table->dropForeign('rates_customer_service_id_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_update_by_foreign');
		});
		Schema::table('car_models', function(Blueprint $table) {
			$table->dropForeign('car_models_create_by_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_role_id_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_create_by_foreign');
		});
		Schema::table('permissions', function(Blueprint $table) {
			$table->dropForeign('permissions_update_by_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_role_id_foreign');
		});
		Schema::table('permission_role', function(Blueprint $table) {
			$table->dropForeign('permission_role_permission_id_foreign');
		});
	}
}