<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('unversities', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('unversities', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('institutes', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('institutes', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('scholarships', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('scholarships', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('articles', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('usre_news_comments', function(Blueprint $table) {
			$table->foreign('news_id')->references('id')->on('news')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('usre_news_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('institute_major', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('institutes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('unversty_major', function(Blueprint $table) {
			$table->foreign('unversity_id')->references('id')->on('unversities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->foreign('unversity_id')->references('id')->on('unversities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('unversity_images')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->foreign('institute_id')->references('id')->on('institutes')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('articles_users_comments', function(Blueprint $table) {
			$table->foreign('articles_id')->references('id')->on('articles')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('articles_users_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultations_users_comments', function(Blueprint $table) {
			$table->foreign('consultation_id')->references('id')->on('consultations')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('consultations_users_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('experiences')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('experiences_user_comments', function(Blueprint $table) {
			$table->foreign('experience_id')->references('id')->on('experiences')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('experiences_user_comments', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('major_scholarship', function(Blueprint $table) {
			$table->foreign('scholarship_id')->references('id')->on('scholarships')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('unversities', function(Blueprint $table) {
			$table->dropForeign('unversities_city_id_foreign');
		});
		Schema::table('unversities', function(Blueprint $table) {
			$table->dropForeign('unversities_admin_id_foreign');
		});
		Schema::table('institutes', function(Blueprint $table) {
			$table->dropForeign('institutes_city_id_foreign');
		});
		Schema::table('institutes', function(Blueprint $table) {
			$table->dropForeign('institutes_admin_id_foreign');
		});
		Schema::table('scholarships', function(Blueprint $table) {
			$table->dropForeign('scholarships_city_id_foreign');
		});
		Schema::table('scholarships', function(Blueprint $table) {
			$table->dropForeign('scholarships_admin_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_country_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_admin_id_foreign');
		});
		Schema::table('articles', function(Blueprint $table) {
			$table->dropForeign('articles_admin_id_foreign');
		});
		Schema::table('usre_news_comments', function(Blueprint $table) {
			$table->dropForeign('usre_news_comments_news_id_foreign');
		});
		Schema::table('usre_news_comments', function(Blueprint $table) {
			$table->dropForeign('usre_news_comments_user_id_foreign');
		});
		Schema::table('institute_major', function(Blueprint $table) {
			$table->dropForeign('institute_major_institute_id_foreign');
		});
		Schema::table('unversty_major', function(Blueprint $table) {
			$table->dropForeign('unversty_major_unversity_id_foreign');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->dropForeign('residence_unversity_id_foreign');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->dropForeign('residence_city_id_foreign');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->dropForeign('residence_image_id_foreign');
		});
		Schema::table('residence', function(Blueprint $table) {
			$table->dropForeign('residence_institute_id_foreign');
		});
		Schema::table('articles_users_comments', function(Blueprint $table) {
			$table->dropForeign('articles_users_comments_articles_id_foreign');
		});
		Schema::table('articles_users_comments', function(Blueprint $table) {
			$table->dropForeign('articles_users_comments_user_id_foreign');
		});
		Schema::table('consultations_users_comments', function(Blueprint $table) {
			$table->dropForeign('consultations_users_comments_consultation_id_foreign');
		});
		Schema::table('consultations_users_comments', function(Blueprint $table) {
			$table->dropForeign('consultations_users_comments_user_id_foreign');
		});
		Schema::table('experiences', function(Blueprint $table) {
			$table->dropForeign('experiences_user_id_foreign');
		});
		Schema::table('experiences_user_comments', function(Blueprint $table) {
			$table->dropForeign('experiences_user_comments_experience_id_foreign');
		});
		Schema::table('experiences_user_comments', function(Blueprint $table) {
			$table->dropForeign('experiences_user_comments_user_id_foreign');
		});
		Schema::table('major_scholarship', function(Blueprint $table) {
			$table->dropForeign('major_scholarship_scholarship_id_foreign');
		});
	}
}