<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCorrectionDataTable extends Migration {

	public function up()
	{
		Schema::create('correction_data', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('data_level');
			$table->string('data_temp')->nullable();
			$table->string('data_pressure')->nullable();
			$table->integer('tank_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('correction_data');
	}
}