<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOauthAccessTokensTable extends Migration {

	public function up()
	{
		Schema::create('oauth_access_tokens', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->nullable();
			$table->bigInteger('client_id')->nullable();
			$table->string('name', 255)->nullable();
			$table->text('scopes')->nullable();
			$table->tinyInteger('revoked');
			$table->datetime('expires_at')->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('oauth_access_tokens');
	}
}